/*
    vhd2vl v 1.0
    VHDL to Verilog RTL translator
    Copyright (C) 2001 Vincenzo Liguori - Ocean Logic Pty Ltd - http://www.ocean-logic.com
    Send comments and bugs at : oceanlogic@yahoo.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

%{
#include <stdio.h>
#include <string.h>
#include "def.h"

int lineno=1;
sglist *io_list=NULL;
sglist *sig_list=NULL;
sglist *type_list=NULL;
char *clkname;
char clkedge;
int delay=1;
int dolist=1;
int np=1;
char wire[]="wire ";
char reg[]="reg ";
int dowith=0;
slist *slwith;
slist *others0=NULL;
slist *others1=NULL;
char *oth0="{1'b0}}";
char *oth1="{1'b1}}";

/* Indentation variables */
int indent=0;
slist *indents[MAXINDENT];

slist *addtxt(slist *sl, char *s){
  slist *p;

  if(s == NULL)
    return sl;

  p = (slist *)malloc(sizeof(slist));
  p->type = 1;
  p->slst = sl;
  p->data.txt = s;

  return p;
}

slist *addptxt(slist *sl, char **s){
  slist *p;

  if(s == NULL)
    return sl;

  p = (slist *)malloc(sizeof(slist));
  p->type = 3;
  p->slst = sl;
  p->data.ptxt = s;

  return p;
}

slist *addval(slist *sl, int val){
  slist *p;

  p = (slist *)malloc(sizeof(slist));
  p->type = 2;
  p->slst = sl;
  p->data.val = val;

  return p;
}

slist *addsl(slist *sl, slist *sl2){
  slist *p;

  if(sl2 == NULL)
    return sl;

  p = (slist *)malloc(sizeof(slist));
  p->type = 0;
  p->slst = sl;
  p->data.sl = sl2;

  return p;
}

slist *addvec(slist *sl, char *s){
  sl=addval(sl,strlen(s));
  sl=addtxt(sl,"'b ");
  sl=addtxt(sl,s);
  return sl;
}

slist *addind(slist *sl){
  if(sl)
    sl=addsl(indents[indent],sl);
  return sl;
}

slist *addpar(slist *sl, vrange *v){
  if(v->hi>-2){
    sl=addtxt(sl,"[");
    if(v->hi>-1){
      sl=addval(sl,v->hi);
      sl=addtxt(sl,":");
    }
    sl=addval(sl,v->lo);
    sl=addtxt(sl,"] ");
  } else
    sl=addtxt(sl," ");
  return sl;
}

slist *addwrap(char *l,slist *sl,char *r){
slist *s;
  s=addtxt(NULL,l);
  s=addsl(s,sl);
  return addtxt(s,r);
}

sglist *lookup(sglist *sg,char *s){
  for(;;){
    if(sg == NULL || strcmp(sg->name,s)==0)
      return sg;
    sg=sg->next;
  }
}

char *bottom(slist *sl){
  while(sl->slst != NULL)
    sl=sl->slst;
  return sl->data.txt;
}

int prec(char op){
  switch(op){
  case 't':
    return 8;
    break;
  case '~':
    return 7;
    break;
  case 'p': case 'm':
    return 6;
    break;
  case '*': case '/':
    return 5;
    break;
  case '+': case '-':
    return 4;
    break;
  case '&':
    return 3;
    break;
  case '^':
    return 2;
    break;
  case '|':
    return 1;
    break;
   default:
    return 0;
    break; 
  }
}

expdata *addexpr(expdata *expr1,char op,char* opstr,expdata *expr2){
slist *sl1,*sl2;
  if(expr1 == NULL)
    sl1=NULL;
  else if(expr1->op == 'c')
    sl1=addwrap("{",expr1->sl,"}");
  else if(prec(expr1->op) < prec(op))
    sl1=addwrap("(",expr1->sl,")");
  else
    sl1=expr1->sl;

  if(expr2->op == 'c')
    sl2=addwrap("{",expr2->sl,"}");
  else if(prec(expr2->op) < prec(op))
    sl2=addwrap("(",expr2->sl,")");
  else
    sl2=expr2->sl;

  if(expr1 == NULL)
    expr1=expr2;
  else
    free(expr2);

  expr1->op=op;
  sl1=addtxt(sl1,opstr);
  sl1=addsl(sl1,sl2);
  expr1->sl=sl1;
  return expr1;
}

void slprint(slist *sl){

  if(sl){
    slprint(sl->slst);
    switch(sl->type){
    case 0 :
      slprint(sl->data.sl);
      break;
    case 1 :
      printf("%s",sl->data.txt);
      break;
    case 2 :
      printf("%d",sl->data.val);
      break;
    case 3 :
      printf("%s",*(sl->data.ptxt));
      break;
    }
  }
}

void slfree(slist *sl){

  if(sl){
    slfree(sl->slst);
    switch(sl->type){
    case 0 :
      slfree(sl->data.sl);
      break;
    case 1 :
      free(sl->data.txt);
      break;
    }
    free(sl);
  }
}

void fslprint(FILE *fp,slist *sl){

  if(sl){
    fslprint(fp,sl->slst);
    switch(sl->type){
    case 0 :
      fslprint(fp,sl->data.sl);
      break;
    case 1 :
      fprintf(fp,"%s",sl->data.txt);
      break;
    case 2 :
      fprintf(fp,"%d",sl->data.val);
      break;
    case 3 :
      fprintf(fp,"%s",*(sl->data.txt));
      break;
    }
  }
}

void fixothers(slval *sgin,slist *sl){
sglist *sg;
int size;

  if(sl->slst){
  /*
    fprintf(stderr,"\n------------------------------\n");
    fprintf(stderr,"Signal %s\n",sgin->sl->data.txt);
  */
    if(sgin->val>0)
      size=sgin->val;
    else{
      if((sg=lookup(io_list,sgin->sl->data.txt))==NULL)
        sg=lookup(sig_list,sgin->sl->data.txt);
      if(sg)
        if(sg->range->hi<0)
          size=1;
        else
          size=abs(sg->range->hi-sg->range->lo)+1;
    }
  /*
    fprintf(stderr,"Size %d\n",size);
    fprintf(stderr,"Ptr %d\n",(int) others1);
  */
    sl->slst->slst->data.val=size;
    sl->data.sl->slst->data.val=size;
  /*
    fslprint(stderr,others1);
  */
  }
}

%}

%union {
  char * txt;  /* String */
  int n; /* Value */
  vrange *v; /* Signal range */
  sglist *sg; /* Signal list */
  slist *sl; /* String list */
  expdata *e; /* Expression structure */
  slval *ss; /* Signal structure */
}

%token <txt> REM ENTITY IS PORT IN OUT MAP
%token <txt> BIT BITVECT DOWNTO TO TYPE END
%token <txt> ARCHITECTURE COMPONENT OF
%token <txt> SIGNAL BEGN NOT WHEN WITH
%token <txt> SELECT OTHERS PROCESS VARIABLE CONSTANT
%token <txt> IF THEN ELSIF ELSE CASE
%token <txt> AFTER AND OR XOR UNIT
%token <txt> LASTVALUE EVENT POSEDGE NEGEDGE
%token <txt> STRING NAME NULLV
%token <n> NATURAL

%type <n> trad
%type <sl> rem  remlist entity
%type <sl> portlist architecture
%type <sl> a_decl a_body p_decl oname
%type <sl> map_list map_item sigvalue
%type <sl> conf exprc sign_list p_body optname
%type <sl> elsepart wlist wvalue cases
%type <sl> with_item with_list doothers
%type <sg> s_list
%type <n> dir delay
%type <v> type vec_range
%type <e> expr
%type <ss> signal

%right '='
/* Logic operators: */
%left ORL
%left ANDL
/* Binary operators: */
%left OR
%left XOR
%left AND
/* Comparison: */
%left '<', '>', BIGEQ, LESSEQ, NOTEQ, EQUAL
%left  '+', '-', '&'
%left  '*', '/'
%right UMINUS, UPLUS, NOTL, NOT
%%

/* Input file must contain entity declaration followed by architecture */
trad  : rem entity rem architecture rem {
        slist *sl;
          sl=addsl($1,$2);
          sl=addsl(sl,$3);
          sl=addsl(sl,$4);
          sl=addsl(sl,$5);
          sl=addtxt(sl,"\nendmodule\n");
          slprint(sl);
          $$=0;
        }
      ;

/* Comments */
rem      : /* Empty */ {$$=NULL; }
         | remlist {$$=$1; }
         ;

remlist  : REM {$$=addtxt(indents[indent],$1);}
         | REM remlist {
           slist *sl;
           sl=addtxt(indents[indent],$1);
           $$=addsl(sl,$2);}
         ;

/* Entity */
entity    : ENTITY NAME IS PORT '(' rem portlist ')' ';' rem END NAME ';' {
            slist *sl;
            sglist *p;
	      sl=addtxt(NULL,"\nmodule ");
              sl=addtxt(sl,$2);
              sl=addtxt(sl,"(\n");
              /* Add the signal list */
              p=io_list;
              for(;;){
                sl=addtxt(sl,p->name);
                p=p->next;
                if(p)
                  sl=addtxt(sl,",\n");
                else{
                  sl=addtxt(sl,"\n");
                  break;
                }
              }
              sl=addtxt(sl,");\n\n");
              sl=addsl(sl,$6);
              sl=addsl(sl,$7);
              sl=addtxt(sl,"\n");
              p=io_list;
              do{
                sl=addptxt(sl,&(p->type));
                /*sl=addtxt(sl,p->type);*/
                sl=addtxt(sl," ");
                sl=addpar(sl,p->range);
                sl=addtxt(sl,p->name);
                sl=addtxt(sl,";\n");
                p=p->next;
              } while(p!=NULL);
              sl=addtxt(sl,"\n");
              sl=addsl(sl,$10);
              $$=addtxt(sl,"\n");
              free($12);
            }
          ;

portlist  : s_list ':' dir type rem {
            slist *sl;
            sglist *p;

	      if(dolist){
	        if($3)
                  sl=addtxt(NULL,"output");
                else
                  sl=addtxt(NULL,"input");

                sl=addpar(sl,$4);
                p=$1;
                for(;;){
                  sl=addtxt(sl,p->name);
                  p=p->next;
                  if(p==NULL)
                    break;
                  sl=addtxt(sl,", ");
                }
                sl=addtxt(sl,";\n");
                $$=addsl(sl,$5);
                io_list=p=$1;
                for(;;){
                  p->type=wire;
                  p->range=$4;
                  if(p->next==NULL)
                    break;
                  p=p->next;
                }
              } else{
                free($5);
                free($4);
              }
            }
          | s_list ':' dir type ';' rem portlist {
            slist *sl;
            sglist *p;

	      if(dolist){
	        if($3)
                  sl=addtxt(NULL,"output");
                else
                  sl=addtxt(NULL,"input");

                sl=addpar(sl,$4);
                p=$1;
                for(;;){
                  sl=addtxt(sl,p->name);
                  p=p->next;
                  if(p==NULL)
                    break;
                  sl=addtxt(sl,", ");
                }
                sl=addtxt(sl,";\n");
                sl=addsl(sl,$6);
                $$=addsl(sl,$7);
                p=$1;
                for(;;){
                  p->type=wire;
                  p->range=$4;
                  if(p->next==NULL)
                    break;
                  p=p->next;
                }
                p->next=io_list;
                io_list=$1;
              } else{
                free($6);
                free($4);
              }
            }
          ;

dir         : IN { $$=0;}
            | OUT { $$=1; }
            ;

type        : BIT {
                $$=(vrange *) malloc(sizeof(vrange));
                $$->hi=-2;
              }
            | BITVECT '('vec_range ')' {$$=$3;}
            | NAME {
              sglist *sg;

	        sg=lookup(type_list,$1);
                if(sg)
                  $$=sg->range;
                else{
                  fprintf(stderr,"Undefined type on line %d\n",lineno);
                  YYABORT;
                }
	      }
            ;

vec_range : NATURAL updown NATURAL {
              $$=(vrange *) malloc(sizeof(vrange));
              $$->hi=$1;
              $$->lo=$3;  
            }
          | NATURAL {
              $$=(vrange *) malloc(sizeof(vrange));
              $$->hi=-1;
              $$->lo=$1;  
            }
          ;

updown : DOWNTO {}
       | TO {}
       ;

/* Architecture */
architecture : ARCHITECTURE NAME OF NAME IS rem a_decl
               BEGN doindent a_body END NAME ';' unindent { 
               slist *sl;

                 sl=addsl($6,$7);
                 sl=addtxt(sl,"\n");
                 $$=addsl(sl,$10);
               }
             ;

/* Extends indentation by one level */
doindent : /* Empty */ {indent= indent < MAXINDENT ? indent + 1 : indent;}
         ;
/* Shorten indentation by one level */
unindent : /* Empty */ {indent= indent > 0 ? indent - 1 : indent;}

/* Declarative part of the architecture */
a_decl    : {$$=NULL;}
          | a_decl SIGNAL s_list ':' type ';' rem {
            sglist *sg;
            slist *sl;
            int size;

              if($5->hi==-1)
                size=1;
              else
                size=($5->hi)-($5->lo);
	      sl=$1;
              sg=$3;
	      for(;;){
                sg->type=wire;
                sg->range=$5;
                sl=addptxt(sl,&(sg->type));
                sl=addpar(sl,$5);
                sl=addtxt(sl,sg->name);
                sl=addtxt(sl,";\n");
	        if(sg->next == NULL)
                  break;
                sg=sg->next;
              }
              sg->next=sig_list;
              sig_list=$3;
              $$=addsl(sl,$7);
            }
          | a_decl CONSTANT NAME ':' type ':' '=' STRING ';' rem {
	    slist * sl;
              sl=addtxt($1,"parameter ");
              sl=addpar(sl,$5);
              free($5);
              sl=addtxt(sl,$3);
              sl=addtxt(sl," = ");
              sl=addvec(sl,$8);
              sl=addtxt(sl,";\n");
              $$=addsl(sl,$10);
            }
          | a_decl TYPE NAME IS '(' s_list ')' ';' rem {
	    slist * sl,*sl2;
            sglist *p;
            int n,k;
	      n=0;
	      sl=NULL;
	      p=$6;
              for(;;){
                sl=addtxt(sl,"  ");
                sl=addtxt(sl,p->name);
                sl=addtxt(sl," = ");
                sl=addval(sl,n++);
                p=p->next;
                if(p==NULL){
                  sl=addtxt(sl,";\n");
                  break;
                } else
                  sl=addtxt(sl,",\n");
              }
              n--;
              k=0;
              if(n&0xff00){
                k|=8;
                n&=0xff00;
              }
              if(n&0xf0f0){
                k|=4;
                n&=0xf0f0;
              }
              if(n&0xcccc){
                k|=2;
                n&=0xcccc;
              }
              if(n&0xaaaa){
                k|=1;
                n&=0xaaaa;
              }
              sl2=addtxt(NULL,"parameter [");
              sl2=addval(sl2,k);
              sl2=addtxt(sl2,":0]\n");
              sl=addsl(sl2,sl);
              sl=addsl($1,sl);
              $$=addsl(sl,$9);
              p=(sglist *) malloc(sizeof(sglist));
              p->name=$3;
              p->range=(vrange *) malloc(sizeof(vrange));
              p->range->lo=0;
              if(k>0)
                p->range->hi=k;
              else
                p->range->hi=-1;
              p->next=type_list;
              type_list=p;
	    }
          | a_decl COMPONENT NAME PORT nolist '(' rem portlist ')' ';' rem END COMPONENT ';' yeslist rem {
	      $$=addsl($1,$16);
              free($3);
              free($7);
              free($11);
            }
          ;

nolist : /*Empty*/ {dolist = 0;}
yeslist : /*Empty*/ {dolist = 1;}

s_list : NAME {
         sglist * sg;
	   if(dolist){
	     sg=(sglist *) malloc(sizeof(sglist));
             sg->name=$1;
             sg->next=NULL;
             $$=sg;
           } else{
             free($1);
             $$=NULL;
           }
         }
       | NAME ',' s_list {
         sglist * sg;
	   if(dolist){
	     sg=(sglist *) malloc(sizeof(sglist));
             sg->name=$1;
             sg->next=$3;
             $$=sg;
           } else{
             free($1);
             $$=NULL;
           }
         }
       ;

a_body : rem {$$=addind($1);}
       | rem signal '<' '=' sigvalue doothers a_body {
         slist *sl;
           sl=addsl($1,indents[indent]);
           sl=addtxt(sl,"assign ");
           sl=addsl(sl,$2->sl);
           fixothers($2,$6);
           free($2);
           sl=addtxt(sl," = ");
           sl=addsl(sl,$5);
           sl=addtxt(sl,";\n");
           $$=addsl(sl,$7);
         }
       | rem WITH expr SELECT rem yeswith signal '<' '=' with_list doothers a_body {
         slist *sl;
         sglist *sg;
         char *s;

           sl=addsl($1,indents[indent]);
           sl=addtxt(sl,"always@() begin // Sensitivity list is empty\n");
           sl=addsl(sl,indents[indent]);
           sl=addtxt(sl,"  case(");
           sl=addsl(sl,$3->sl);
           free($3);
           sl=addtxt(sl,")\n");
           if($5)
             sl=addsl(sl,$5);
	   s=bottom($7->sl);
           if((sg=lookup(io_list,s))==NULL)
             sg=lookup(sig_list,s);
           if(sg)
             sg->type=reg;
           fixothers($7,$11);
           free($7);
           sl=addsl(sl,$10);
           sl=addsl(sl,indents[indent]);
           sl=addtxt(sl,"  endcase\n");
           sl=addsl(sl,indents[indent]);
           sl=addtxt(sl,"end\n\n");
           $$=addsl(sl,$12);
         }
       | rem NAME ':' NAME PORT MAP '(' doindent map_list ')' ';' unindent a_body {
         slist *sl;
           sl=addsl($1,indents[indent]);
           sl=addtxt(sl,$4);
           sl=addtxt(sl," ");
           sl=addtxt(sl,$2);
           sl=addtxt(sl,"(\n");
           sl=addsl(sl,indents[indent]);
           sl=addsl(sl,$9);
           sl=addtxt(sl,");\n\n");
           $$=addsl(sl,$13);
         }
       | optname PROCESS '(' sign_list ')' p_decl BEGN doindent p_body END PROCESS oname ';' unindent a_body {
         slist *sl;
         char *s;
           sl=addsl($1,indents[indent]);
	   sl=addtxt(sl,"always @(");
           sl=addsl(sl,$4);
	   sl=addtxt(sl,") begin");
           if($6){
             sl=addtxt(sl," : P");
             s=(char *) malloc(6*sizeof(char));
             sprintf(s,"%d\n",np++);
             sl=addtxt(sl,s);
             sl=addsl(sl,$6);
           }
	   sl=addtxt(sl,"\n");
           sl=addsl(sl,$9);
           sl=addsl(sl,indents[indent]);
           sl=addtxt(sl,"end\n\n");
           $$=addsl(sl,$15);
         }
       | optname PROCESS '(' sign_list ')' p_decl BEGN doindent
           rem IF edge THEN p_body END IF ';'
           END PROCESS oname ';' unindent a_body {
           slist *sl;
           char *s;
             sl=addsl($1,indents[indent]);
	     sl=addtxt(sl,"always @(");
             if(clkedge)
	       sl=addtxt(sl,"posedge ");
             else
	       sl=addtxt(sl,"negedge ");
	     sl=addtxt(sl,clkname);
	     sl=addtxt(sl,") begin");
             if($6){
               sl=addtxt(sl," : P");
               s=(char *) malloc(6*sizeof(char));
               sprintf(s,"%d\n",np++);
               sl=addtxt(sl,s);
               sl=addsl(sl,$6);
             }
	     sl=addtxt(sl,"\n");
             if($9){
               sl=addsl(sl,indents[indent]);
               sl=addsl(sl,$9);
	     }
             sl=addsl(sl,$13);
             sl=addsl(sl,indents[indent]);
             sl=addtxt(sl,"end\n\n");
             $$=addsl(sl,$22);
         }
       | optname PROCESS '(' sign_list ')' p_decl BEGN doindent
           rem IF exprc THEN doindent p_body unindent ELSIF edge THEN doindent p_body unindent END IF ';'
           END PROCESS oname ';' unindent a_body {
           slist *sl;
           char *s;
             sl=addsl($1,indents[indent]);
	     sl=addtxt(sl,"always @(");
             if(clkedge)
	       sl=addtxt(sl,"posedge ");
             else
	       sl=addtxt(sl,"negedge ");
	     sl=addtxt(sl,clkname);
             if($11->data.sl->data.txt[0]-'0')
	       sl=addtxt(sl," or posedge ");
             else
	       sl=addtxt(sl," or negedge ");
	     sl=addtxt(sl,$11->slst->slst->data.txt);
	     sl=addtxt(sl,") begin");
             if($6){
               sl=addtxt(sl," : P");
               s=(char *) malloc(6*sizeof(char));
               sprintf(s,"%d\n",np++);
               sl=addtxt(sl,s);
               sl=addsl(sl,$6);
             }
	     sl=addtxt(sl,"\n");
             if($9){
               sl=addsl(sl,indents[indent]);
               sl=addsl(sl,$9);
	     }
             sl=addsl(sl,indents[indent]);
             sl=addtxt(sl,"  if(");
             sl=addsl(sl,$11);
	     sl=addtxt(sl,") begin\n");
             sl=addsl(sl,$14);
             sl=addsl(sl,indents[indent]);
             sl=addtxt(sl,"  end else begin\n");
             sl=addsl(sl,$20);
             sl=addsl(sl,indents[indent]);
             sl=addtxt(sl,"  end\n");
             sl=addsl(sl,indents[indent]);
             sl=addtxt(sl,"end\n\n");
             $$=addsl(sl,$30);
         }
       ;

oname : {$$=NULL;}
      | NAME {free($1); $$=NULL;}
      ;

optname : rem {$$=$1;}
        | rem NAME ':' {$$=$1; free($2);}
        ;

edge : NAME '\'' EVENT AND exprc {
         clkname=$1;
         clkedge=$5->data.txt[0]-'0';
         /* slfree($5); */
       }
     | exprc AND NAME '\'' EVENT {
         clkname=$3;
         clkedge=$1->data.txt[0]-'0';
         /* slfree($1); */
       }
     | POSEDGE '(' NAME ')' {
         clkname=$3;
         clkedge=1;
       }
     | NEGEDGE '(' NAME ')' {
         clkname=$3;
         clkedge=0;
       }
     ;

yeswith : {dowith=1;}

doothers : {
             slist *sl;
               sl=(slist *) malloc(sizeof(slist));
               sl->slst=others0;
               sl->data.sl=others1;
               others0=NULL;
               $$=sl;
            }

with_list : with_item ';' {$$=$1;}
          | with_item ',' rem with_list {
            slist *sl;
	      if($3){
                sl=addsl($1,$3);
                $$=addsl(sl,$4);
              } else
                $$=addsl($1,$4);
            }
          | expr delay WHEN OTHERS ';' {
            slist *sl;
	      sl=addtxt(indents[indent],"    default : ");
              sl=addsl(sl,slwith);
	      sl=addtxt(sl," <= ");
	      if(delay && $2){
                sl=addtxt(sl,"# ");
                sl=addval(sl,$2);
                sl=addtxt(sl," ");
              }
              if($1->op == 'c')
                sl=addsl(sl,addwrap("{",$1->sl,"}"));
              else
                sl=addsl(sl,$1->sl);
              free($1);
              delay=1;
	      $$=addtxt(sl,";\n");
            }

with_item : expr delay WHEN wlist {
            slist *sl;
	      sl=addtxt(indents[indent],"    ");
	      sl=addsl(sl,$4);
	      sl=addtxt(sl," : ");
              sl=addsl(sl,slwith);
	      sl=addtxt(sl," <= ");
	      if(delay && $2){
                sl=addtxt(sl,"# ");
                sl=addval(sl,$2);
                sl=addtxt(sl," ");
              }
              if($1->op == 'c')
                sl=addsl(sl,addwrap("{",$1->sl,"}"));
              else
                sl=addsl(sl,$1->sl);
              free($1);
              delay=1;
	      $$=addtxt(sl,";\n");
            }

p_decl : rem {$$=$1};
       | rem VARIABLE s_list ':' type ';' p_decl {
         slist *sl;
         sglist *sg, *p;
	   sl=addtxt($1,"    reg ");
           sl=addpar(sl,$5);
           free($5);
           sg=$3;
           for(;;){
             sl=addtxt(sl,sg->name);
             p=sg;
             sg=sg->next;
             free(p);
             if(sg)
               sl=addtxt(sl,",");
             else
               break;
           }
           sl=addtxt(sl,";\n");
           $$=addsl(sl,$7);
         }
       ;

p_body : rem {$$=$1;}
       | rem signal ':' '=' expr ';' doothers p_body {
         slist *sl;
           sl=addsl($1,indents[indent]);
           sl=addsl(sl,$2->sl);
           fixothers($2,$7);
           sl=addtxt(sl," = ");
           if($5->op == 'c')
             sl=addsl(sl,addwrap("{",$5->sl,"}"));
           else
             sl=addsl(sl,$5->sl);
           free($5);
           sl=addtxt(sl,";\n");
           $$=addsl(sl,$8);
         }
       | rem signal '<' '=' sigvalue doothers p_body {
         slist *sl;
         sglist *sg;
         char *s;

	   s=bottom($2->sl);
           if((sg=lookup(io_list,s))==NULL)
             sg=lookup(sig_list,s);
           if(sg)
             sg->type=reg;
           sl=addsl($1,indents[indent]);
           sl=addsl(sl,$2->sl);
           fixothers($2,$6);
           sl=addtxt(sl," <= ");
           sl=addsl(sl,$5);
           sl=addtxt(sl,";\n");
           $$=addsl(sl,$7);
         }
       | rem IF exprc THEN doindent p_body unindent elsepart END IF ';' p_body {
         slist *sl;
           sl=addsl($1,indents[indent]);
           sl=addtxt(sl,"if(");
           sl=addsl(sl,$3);
           sl=addtxt(sl,") begin\n");
           sl=addsl(sl,$6);
           sl=addsl(sl,indents[indent]);
           sl=addtxt(sl,"end\n");
           sl=addsl(sl,$8);
           $$=addsl(sl,$12);         
         }
       | rem CASE signal IS rem cases END CASE ';' p_body {
         slist *sl;
           sl=addsl($1,indents[indent]);
           sl=addtxt(sl,"case(");
           sl=addsl(sl,$3->sl);
           sl=addtxt(sl,")\n");
           if($5){
             sl=addsl(sl,indents[indent]);
             sl=addsl(sl,$5);
           }
           sl=addsl(sl,$6);
           sl=addsl(sl,indents[indent]);
           sl=addtxt(sl,"endcase\n");
           $$=addsl(sl,$10);           
         }
       | rem NULLV ';' p_body {
         slist *sl;
           if($1){
             sl=addsl($1,indents[indent]);
             $$=addsl(sl,$4);
           }else
             $$=$4;
         }
       ;

elsepart : {$$=NULL;}
         | ELSIF exprc THEN doindent p_body unindent elsepart {
           slist *sl;
             sl=addtxt(indents[indent],"else if(");
             sl=addsl(sl,$2);
             sl=addtxt(sl,") begin\n");
             sl=addsl(sl,$5);
             sl=addsl(sl,indents[indent]);
             sl=addtxt(sl,"end\n");
             $$=addsl(sl,$7);
           }
         | ELSE doindent p_body unindent {
           slist *sl;
             sl=addtxt(indents[indent],"else begin\n");
             sl=addsl(sl,$3);
             sl=addsl(sl,indents[indent]);
             $$=addtxt(sl,"end\n");
           }
         ;

cases : WHEN wlist '=' '>' doindent p_body unindent cases{
        slist *sl;
          sl=addsl(indents[indent],$2);
          sl=addtxt(sl," : begin\n");
          sl=addsl(sl,$6);
          sl=addsl(sl,indents[indent]);
          sl=addtxt(sl,"end\n");
          $$=addsl(sl,$8);
        }
      | WHEN OTHERS '=' '>' doindent p_body unindent {
        slist *sl;
          sl=addtxt(indents[indent],"default : begin\n");
          sl=addsl(sl,$6);
          sl=addsl(sl,indents[indent]);
          $$=addtxt(sl,"end\n");
        }
      ;

wlist : wvalue {$$=$1;}
      | wlist '|' wvalue {
        slist *sl;
	  sl=addtxt($1,",");
          $$=addsl(sl,$3);
        }
      ;

wvalue : STRING {$$=addvec(NULL,$1);}
       | NAME {$$=addtxt(NULL,$1);}
       ;

sign_list : signal {$$=$1->sl; free($1);}
          | signal ',' sign_list {
            slist *sl;
              sl=addtxt($1->sl," or ");
              free($1);
              $$=addsl(sl,$3);
            }
          ;

sigvalue : expr delay ';' {
           slist *sl;
	     if(delay && $2){
               sl=addtxt(NULL,"# ");
               sl=addval(sl,$2);
               sl=addtxt(sl," ");
             } else
               sl=NULL;
             if($1->op == 'c')
               sl=addsl(sl,addwrap("{",$1->sl,"}"));
             else
               sl=addsl(sl,$1->sl);
             free($1);
             delay=1;
             $$=sl;
           }
         | expr delay WHEN exprc ';' {
	     fprintf(stderr,"Warning on line %d :\nCan't translate expr delay WHEN exprc';' expressions\n",lineno);
             $$=NULL;
           }
         | expr delay WHEN exprc ELSE nodelay sigvalue {
           slist *sl;
	     sl=addtxt($4," ? ");
             if($1->op == 'c')
               sl=addsl(sl,addwrap("{",$1->sl,"}"));
             else
	       sl=addsl(sl,$1->sl);
             free($1);
	     sl=addtxt(sl," : ");
	     $$=addsl(sl,$7);
           }
         ;

nodelay  : /* empty */ {delay=0;}
         ;

delay    : /* empty */ {$$=0;}
         | AFTER NATURAL UNIT {$$=$2;}
         ;

map_list : rem map_item {
           slist *sl;
           sl=addsl($1,indents[indent]);
           $$=addsl(sl,$2);}
         | rem map_item ',' map_list {
           slist *sl;
             sl=addsl($1,indents[indent]);
	     sl=addsl(sl,$2);
	     sl=addtxt(sl,",\n");
	     $$=addsl(sl,$4);
           }
         ;

map_item : signal {$$=$1->sl; free($1);}
         | NAME '=' '>' signal {
           slist *sl;
	     sl=addtxt(NULL,".");
	     sl=addtxt(sl,$1);
	     sl=addtxt(sl,"(");
	     sl=addsl(sl,$4->sl);
             free($4);
	     $$=addtxt(sl,")");
           }
         ;

signal : NAME {
         slist *sl;
         slval *ss;

	   ss=(slval *) malloc(sizeof(slval));
           sl=addtxt(NULL,$1);
           if(dowith){
             slwith=sl;
             dowith=0;
           }
           ss->sl=sl;
           ss->val=-1;
           $$=ss;
         }
       | NAME '('vec_range ')' {
         slval *ss;
         slist *sl;
	   ss=(slval *) malloc(sizeof(slval));
           sl=addtxt(NULL,$1);
           sl=addpar(sl,$3);
           if(dowith){
             slwith=sl;
             dowith=0;
           }
           ss->sl=sl;
           if($3->hi==-1)
             ss->val=1;
           else
             ss->val=abs($3->hi-$3->lo)+1;
           free($3);
           $$=ss;
         }
       ;

/* Expressions */
expr : signal {
         expdata *e;
           e=(expdata *) malloc(sizeof(expdata));
           e->op='t'; /* Terminal symbol */
           e->sl=$1->sl;
           free($1);
           $$=e;
         }
     | STRING {
         expdata *e;
           e=(expdata *) malloc(sizeof(expdata));
           e->op='t'; /* Terminal symbol */
           e->sl=addvec(NULL,$1);
           $$=e;
         }
     | '(' OTHERS '=' '>' STRING ')' {
         expdata *e;
           e=(expdata *) malloc(sizeof(expdata));
           e->op='t'; /* Terminal symbol */
           if(others0 == NULL){
             others0=addtxt(NULL,"{");
             others0=addval(others0,0);
             others0=addtxt(others0,oth0);
             others1=addtxt(NULL,"{");
             others1=addval(others1,0);
             others1=addtxt(others1,oth1);
           }
           e->sl=$5[0] == '0' ? others0 : others1;
           $$=e;
         }
     | expr '&' expr { /* Vector chaining */
         slist *sl;
           sl=addtxt($1->sl,",");
           sl=addsl(sl,$3->sl);
           free($3);
           $1->op='c';
           $1->sl=sl;
           $$=$1;
         }
     | '-' expr %prec UMINUS {$$=addexpr(NULL,'m'," -",$2);}
     | '+' expr %prec UPLUS {$$=addexpr(NULL,'p'," +",$2);}
     | expr '+' expr {$$=addexpr($1,'+'," + ",$3);}
     | expr '-' expr {$$=addexpr($1,'-'," - ",$3);}
     | expr '*' expr {$$=addexpr($1,'*'," * ",$3);}
     | expr '/' expr {$$=addexpr($1,'/'," / ",$3);}
     | NOT expr {$$=addexpr(NULL,'~'," ~",$2);}
     | expr AND expr {$$=addexpr($1,'&'," & ",$3);}
     | expr OR expr {$$=addexpr($1,'|'," | ",$3);}
     | expr XOR expr {$$=addexpr($1,'^'," ^ ",$3);}
     | '(' expr ')' {$$=$2; }
     ;

/* Conditional expressions */
exprc : conf { $$=$1; }
      | '(' exprc ')' {$$=addwrap("(",$2,")");}
      | exprc AND exprc %prec ANDL {
        slist *sl;
          sl=addtxt($1," && ");
          $$=addsl(sl,$3);
        }
      | exprc OR exprc %prec ORL {
        slist *sl;
          sl=addtxt($1," || ");
          $$=addsl(sl,$3);
        }
      | NOT exprc %prec NOTL {
        slist *sl;
          sl=addtxt(NULL,"!");
          $$=addsl(sl,$2);
        }
      ;

/* Comparisons */
conf : expr '=' expr %prec EQUAL {
       slist *sl;
         if($1->op == 'c')
           sl=addwrap("{",$1->sl,"} == ");
         else if($1->op != 't')
           sl=addwrap("(",$1->sl,") == ");
         else
           sl=addtxt($1->sl," == ");
         if($3->op == 'c')
           $$=addsl(sl,addwrap("{",$3->sl,"}"));
         else if($3->op != 't')
           $$=addsl(sl,addwrap("(",$3->sl,")"));
         else
           $$=addsl(sl,$3->sl);
         free($1);
         free($3);
       }
     | expr '>' expr {
       slist *sl;
         if($1->op == 'c')
           sl=addwrap("{",$1->sl,"} > ");
         else if($1->op != 't')
           sl=addwrap("(",$1->sl,") > ");
         else
           sl=addtxt($1->sl," > ");
         if($3->op == 'c')
           $$=addsl(sl,addwrap("{",$3->sl,"}"));
         else if($3->op != 't')
           $$=addsl(sl,addwrap("(",$3->sl,")"));
         else
           $$=addsl(sl,$3->sl);
         free($1);
         free($3);
       }
     | expr '>' '=' expr %prec BIGEQ {
       slist *sl;
         if($1->op == 'c')
           sl=addwrap("{",$1->sl,"} >= ");
         else if($1->op != 't')
           sl=addwrap("(",$1->sl,") >= ");
         else
           sl=addtxt($1->sl," >= ");
         if($4->op == 'c')
           $$=addsl(sl,addwrap("{",$4->sl,"}"));
         else if($4->op != 't')
           $$=addsl(sl,addwrap("(",$4->sl,")"));
         else
           $$=addsl(sl,$4->sl);
         free($1);
         free($4);
       }
     | expr '<' expr {
       slist *sl;
         if($1->op == 'c')
           sl=addwrap("{",$1->sl,"} < ");
         else if($1->op != 't')
           sl=addwrap("(",$1->sl,") < ");
         else
           sl=addtxt($1->sl," < ");
         if($3->op == 'c')
           $$=addsl(sl,addwrap("{",$3->sl,"}"));
         else if($3->op != 't')
           $$=addsl(sl,addwrap("(",$3->sl,")"));
         else
           $$=addsl(sl,$3->sl);
         free($1);
         free($3);
       }
     | expr '<' '=' expr %prec LESSEQ {
       slist *sl;
         if($1->op == 'c')
           sl=addwrap("{",$1->sl,"} <= ");
         else if($1->op != 't')
           sl=addwrap("(",$1->sl,") <= ");
         else
           sl=addtxt($1->sl," <= ");
         if($4->op == 'c')
           $$=addsl(sl,addwrap("{",$4->sl,"}"));
         else if($4->op != 't')
           $$=addsl(sl,addwrap("(",$4->sl,")"));
         else
           $$=addsl(sl,$4->sl);
         free($1);
         free($4);
       }
     | expr '/' '=' expr %prec NOTEQ {
       slist *sl;
         if($1->op == 'c')
           sl=addwrap("{",$1->sl,"} != ");
         else if($1->op != 't')
           sl=addwrap("(",$1->sl,") != ");
         else
           sl=addtxt($1->sl," != ");
         if($4->op == 'c')
           $$=addsl(sl,addwrap("{",$4->sl,"}"));
         else if($4->op != 't')
           $$=addsl(sl,addwrap("(",$4->sl,")"));
         else
           $$=addsl(sl,$4->sl);
         free($1);
         free($4);
       }
     ;
%%

char *outfile;    /* Output file */
char *sourcefile; /* Input file */

main(int argc, char *argv[]){
int i,j;
char *s;
slist *sl;

  fprintf(stderr, "vhd2vl v 1.0,  VHDL to Verilog RTL translator\n");
  fprintf(stderr, "Copyright (C) 2001 Vincenzo Liguori - Ocean Logic Pty Ltd - http://www.ocean-logic.com\n");
  fprintf(stderr, "vhd2vl comes with ABSOLUTELY NO WARRANTY\n");
  fprintf(stderr, "This is free software, and you are welcome to redistribute it\n");
  fprintf(stderr, "under certain conditions.\n"); 
  fprintf(stderr, "See the license file license.txt included with the source for details.\n\n");

  /* Init the indentation variables */
  indents[0]=NULL;
  for(i=1;i<MAXINDENT;i++){
    indents[i]=sl=(slist *) malloc(sizeof(slist));
    sl->data.txt=s=(char *) malloc(sizeof(char) *((i<<1)+1));
    for(j=0;j<(i<<1);j++)
      *s++=' ';
    *s=0;
    sl->type=1;
    sl->slst=NULL;
  }

  sourcefile = argv[1];
  outfile = argv[2];

  if (!freopen(sourcefile, "r", stdin)) {
     fprintf(stderr, "Error: Can't open input file '%s'\n", sourcefile);
     return(1);
     }

  if (!freopen(outfile, "w", stdout)) {
     fprintf(stderr, "Error: Can't open output file '%s'\n", outfile);
     fclose(stdin);
     return(1);
     }

  printf("// File translated with vhd2vl v 1.0\n// VHDL to Verilog RTL translator\n");
  printf("// Copyright (C) 2001 Vincenzo Liguori - Ocean Logic Pty Ltd - http://www.ocean-logic.com\n");
  printf("// vhd2vl comes with ABSOLUTELY NO WARRANTY\n");
  printf("// This is free software, and you are welcome to redistribute it\n");
  printf("// under certain conditions.\n"); 
  printf("// See the license file license.txt included with the source for details.\n\n");

  yyparse();
  fclose(stdout);
  fclose(stdin);
}

