/*
    vhd2vl v 1.0
    VHDL to Verilog RTL translator
    Copyright (C) 2001 Vincenzo Liguori - Ocean Logic Pty Ltd - http://www.ocean-logic.com
    Send comments and bugs at : oceanlogic@yahoo.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

%{
#include <stdio.h>
#include <string.h>
#include "def.h"
#include "vhd2vl.tab.h"

extern int lineno;

void getstring(int skip);

%}
%%

[ \t] {;}

"--".*\n {
  yylval.txt=(char *)malloc(strlen(yytext)+1);
  strcpy(yylval.txt, yytext);
  yylval.txt[0]='/'; 
  yylval.txt[1]='/';
  lineno++; 
  return REM; }

"library ".*\n {lineno++;}
"use ".*\n {lineno++;}

"\x0d\n" |
\n { lineno++;}

"entity" { return ENTITY; }
"is" { return IS; }
"port" { return PORT; }
"map" { return MAP; }
"in" { return IN; }
"out" { return OUT; }
"std_logic" |
"std_ulogic" { return BIT; }
"std_logic_vector" |
"std_ulogic_vector"  { return BITVECT; }
"downto" { return DOWNTO; }
"to" { return TO; }
"type" {return TYPE; }
"end" { return END; }
"architecture" { return ARCHITECTURE; }
"component" { return COMPONENT; }
"of" { return OF; }
"signal" { return SIGNAL; }
"begin" { return BEGN; }
"not" { return NOT; }
"when" { return WHEN; }
"with" {
  fprintf(stderr,"Warning : WITH statment on line %d will have a empty sensitivity list\n",lineno);
  return WITH; }
"select" { return SELECT; }
"others" { return OTHERS; }
"process" { return PROCESS; }
"variable" { return VARIABLE; }
"constant" { return CONSTANT; }
"null" { return NULLV; }
"if" { return IF; }
"then" { return THEN; }
"elsif" { return ELSIF; }
"else" { return ELSE; }
"case" { return CASE; }
"after" { return AFTER; }
"and" { return AND; }
"or" { return OR; }
"xor" { return XOR; }
"ns" |
"ps" |
"ms" |
"us" { return UNIT; }
"event" { return EVENT; }
"rising_edge" { return POSEDGE;}
"falling_edge" { return NEGEDGE;}

\"[ \!#-~]*\" |
\'[0-1]\' { getstring(1); return STRING;}


[a-zA-Z_$][a-zA-Z0-9_$.]* {
  yylval.txt=(char *)malloc(strlen(yytext)+1);
  strcpy(yylval.txt, yytext);
  return NAME;
}

[0-9]+ {
  sscanf(yytext, "%d", &yylval.n);
  return NATURAL;
}

. { return yytext[0]; }

%%

void getstring(int skip){
/* Gets a string excluding " or ' */
int i;

  for(i=skip; yytext[i]!='"' && yytext[i]!='\'' && yytext[i]!=0; i++);
  yytext[i]=0;
  yylval.txt=(char *)malloc(i+1);
  strcpy(yylval.txt, yytext+skip);
}


yyerror(char *s){
  fprintf(stderr,"%s on line %d\n",s,lineno);
  fprintf(stderr,"Token %s\n",yytext);
}
