/*
    vhd2vl v 1.0
    VHDL to Verilog RTL translator
    Copyright (C) 2001 Vincenzo Liguori - Ocean Logic Pty Ltd - http://www.ocean-logic.com
    Send comments and bugs at : oceanlogic@yahoo.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __def_h
#define __def_h

#define MAXINDENT 36

typedef struct signal {
  char *name; /* Signal name */
  int reg; /* Verilog reg */
  struct signal *next;
} signal;

typedef struct vrange {
  short hi, lo;
} vrange;

typedef struct nlist {
  char *name; /* Name */
  struct nlist *next;
} nlist;

typedef struct slist {
  unsigned int type : 2;
  struct slist *slst;
  union {
    struct slist *sl;
    char *txt;
    char **ptxt;
    int val;
  } data;
} slist;

typedef struct slval {
  slist *sl;
  int val; /* Signal size */
} slval;

typedef struct expdata {
  char op;
  slist *sl;
} expdata;

typedef struct sglist {
  char *name; /* Signal name */
  char *type; /* Reg or wire */
  vrange *range; /* Signal size */
  struct sglist *next;
} sglist;

#endif
