//---------------------------------------------------------------------------
#ifndef multilevelH
#define multilevelH
#include <LEDA/graph.h>
#include "customdesign.h"
#include "detailtile.h"

//note:avg pins in a cell = 3
#define Pins_In_A_Tile 3*5	//define how many cells can in a tile(threshold)

struct Tile_{
	//rectangle enclose the tile
	int lx, rx, by, ty;
	int hdemand, vdemand;	//resource demand for h and v routing
	DetailTile *dt;
	Tile_()
	{
		dt = NULL;
	}
};
struct Level_{
	vector <Tile_> tiles;
	//total tiles = n*n
	int n;
	int hcapacity, vcapacity;	//resource(capacity) for h and v routing in a tile
					//(used to calculate density)
	int tile_width, tile_height;
	Level_()
	{
		tiles.clear();
	}
};
struct TilePath_{
	vector <int> tiles;
	double cost;
};

enum MultilevelType {Routibility, PerformanceDriven};

class Multilevel{
  public:
	Multilevel(){};
	Multilevel(CustomDesign *cd, float *args);
	~Multilevel();
    
	//variables
	vector <Level_> levels;
	CustomDesign *CD;
	//should move to private, now is testing
	void PerformanceUnCoarsen();
	bool SatisfyRestrictedTimingConstraint(CIP_ *sink);
	int GetDTGridValue(int t_index, int n, int m, int l, int dir);

	//Detail grid m,n(how many detailed grids in a DT?) m is width. n is height
	int dt_m, dt_n;
	int multilevel_type;

	
  private:
	int CalculateResourceFromPreLevel(Level_ *pre_level, int i, int j, int type);
	void ConstructLevel(Level_ *pre_level, Level_ &l, int n);
	void ConstructFirstLevel(int n);
	int CalculateHResource(int x_gap);
	int CalculateVResource(int y_gap);
	int TileIndex(int ax, int ay, Level_ l);
	void DoMultilevel(int initial_titles);
	int Level0TileXIndexDiff(CIP_ source, CIP_ target);
	int Level0TileYIndexDiff(CIP_ source, CIP_ target);
	void Coarsen(int initial_titles);
	void Level0TileXIndex(CIP_ source, CIP_ target, int &x1, int &x2);
	void Level0TileYIndex(CIP_ source, CIP_ target, int &y1, int &y2);
	double GetCost(Level_ *l, int index, int type);
	void PatternRouting(Edge_ *e);
	void ZShapeRouting(Edge_ *e);
	void Report();
	int Level0TileIndex(CIP_ c);
	int Level0TileXIndexDiff2(int pos1, int pos2);
	int Level0TileYIndexDiff2(int pos1, int pos2);
	bool DetailRoute(int type);
	bool DetailedMazeSearching(int &s_x, int &s_y, int t_x, int t_y, int mark, int Obstacle, int &);
	void BacktraceToFindPath(int s_x, int s_y, int t_x, int t_y, int mark, int route_type, int &vias);
	void MarkAllPinsOccupied();
	void Coarsen1(int initial_titles);
	void UnCoarsen();
	void GlobalMazeRouting(Edge_ *e);
	void PerformanceCoarsen(int t);
	bool RecallingModified(Edge_ *e);
	bool RelaxedSatisfyTimingConstraint(CIP_ *sink);
	void DoPerformanceMultilevel(int tiles);
	void CalculateNetUpperAndLowerBound();
	bool NetsTimingAnalysis(int);
	void DFSTimingAnalysis(CIP_ *cpi, double up_delay);
	double RoughDownStreamCapaciteance(CIP_ *cpi);
	void RoughAnalysisNetTreeDelay(int net_id);
	bool TheSameNet(int v1, int v2);
	void ReportEachNetTiming();

	vector <int> h_maze_area;
	vector <int> v_maze_area;
	int maze_width, maze_height;
	int net_fail;

	leda_list <Edge_*> edges_to_detail_route;
	leda_list <Edge_*> edges_failed_to_detail_route_at_coarsen;

	//variables use for Multilevel type check
	float alpha;

	//temp debug variables
	int debug_print;
	int debug_count;

	int constraint_net;
	int constraint_edges;

	double control_ration;	//use to control timing slack
	leda_list <Net_ *> net_to_be_handle;
};
//---------------------------------------------------------------------------
#endif