//---------------------------------------------------------------------------
/*
	Main file:Run the "Multilevel Performance-Driven Routing"
	other files:
	"main.cc" "multilevel.cc" "multilevel.h" "customdesign.cc" "customdesign.h" "detailtile.cc" "detailtile.h"
*/

#include <LEDA/window.h>
#include <LEDA/color.h>
#include <LEDA/graph.h>
#include <stdlib.h>
#include <vector>
#include <string>
#include <time.h>
#include <sys/timeb.h>
#include <sys/time.h>
#include "multilevel.h"
#include "customdesign.h"

//variables to control Drawing
int draw_box = 0;
int draw_name = 0;
int show_grid = 0;
int show_edge = 1;
int Show_Detail_Grid = 0;
int show_net = -1;
int show_other_nets = 0;
double scale = 1;
int l_shape_routing = 0;
int point_size = 1500;
int DT_index = 0;
int Layers = 0;
int step_edge_route = 0;
int Show_all_layer = 0;

leda_string message;
leda_window W;

CustomDesign *CD;
Multilevel *ML;

//variables to control debug
int debug_print = 0;

/*
	tήɶ
*/
double seconds()
{
#ifdef BSD       // BSD system instead of SYSV
	rusage time;
	getrusage(RUSAGE_SELF,&time);
	return (double)(1.0*time.ru_utime.tv_sec+0.000001*time.ru_utime.tv_usec);
#else
	return double(clock())/CLOCKS_PER_SEC;
#endif
}

/*
	Convert a integer to a char array.
	Negative number is also supported now.
*/
char* IntToString(int a)
{
	static char tmp[50];
	strcpy(tmp,"");
	int start = 0, a1 = a;
	if(a == 0)	return "0";
	if(a<0){start = 1;tmp[0] = '-';a1=(-1)*a;}
	int b = a1;
	int digital = 0;
	while(b){digital++;b/=10;}
	b = a1;
	for(int i=start;i<digital+start;i++)
	{
		int div = 1;
		for(int j=i;j<digital+start-1;j++)	div*=10;
		tmp[i] = b/div + '0';
		b = b - (b/div)*div;
	}
	tmp[digital+start] = '\0';
	return tmp;
}
/*
	Convert a double to a char array.
	Negative number is also supported now.
*/
char* doubleToString(double a)
{
	static char tmp[50];
	strcpy(tmp,"");
	double a1 = a;
	if(a == 0)	return "0";
	if(a<0){strcpy(tmp,"-");a1=(-1)*a;}
	int b = (int)a1;
	double diff = a1 - b*(1.0);
	if(diff==0)
	{
		strcat(tmp, IntToString(b));	//maybe negative
		return IntToString(b);
	}
	strcat(tmp, IntToString(b));
	strcat(tmp, ".");
	double diff1 = diff;
	while(diff1 != 0)
	{
		diff1*=10;
		strcat(tmp, IntToString((int)diff1));
		diff1 = diff1 - (int)diff1;
	}
	strcat(tmp, IntToString((int)diff));
	return tmp;
}

void SetCIDraw(CustomDesign *CD)
{
	for(int i=0;i<CD->cellinstances.size();i++)
		CD->cellinstances[i].draw = 1;
	for(int i=0;i<CD->cellinstancepins.size();i++)
		CD->cellinstancepins[i].draw = 1;
}
/*
	if the same sign return 1
	else return 0
*/
int SameSign(int a, int b)
{
	if(a<0 && b<0 || a>0 && b>0)
		return 1;
	return 0;
}

void ResetCIDraw(CustomDesign *CD)
{
	for(int i=0;i<CD->cellinstances.size();i++)
		CD->cellinstances[i].draw = 0;
	for(int i=0;i<CD->cellinstancepins.size();i++)
		CD->cellinstancepins[i].draw = 0;
}
/*
	total colors:
	black, white, red, green, blue, yellow, violet, orange
	cyan, brown, pink, green2, blue2, grey1, grey2, grey3. 
*/
int GetColor(int level)
{
	if(level == 0)
		return leda_green;
	else if(level == 1)
		return leda_red;
	else if(level == 2)
		return leda_green2;
	else if(level == 3)
		return leda_pink;
	else if(level == 4)
		return leda_violet;
	else
		return leda_orange;
}
void ShowNetwork (CustomDesign *CD, Multilevel *ML)
{
	if(!ML)	return;
	W.set_color(leda_white);
	//show each cell instance
	for(int i=1;i<CD->cellinstances.size();i++)
	{
		if(!CD->cellinstances[i].draw)	continue;
//		if(CD->cellinstances[i].not_conn_pins != CD->cellinstances[i].pins_uid.size())
//		{
			int minx = INT_MAX, miny = INT_MAX;
			int maxx = INT_MIN, maxy = INT_MIN;
			for(int j=0;j<CD->cellinstances[i].pins_uid.size();j++)
			{
				int id = CD->cellinstances[i].pins_uid[j];
				if(CD->cellinstancepins[id].ax < minx)	minx = CD->cellinstancepins[id].ax;
				if(CD->cellinstancepins[id].ax > maxx)	maxx = CD->cellinstancepins[id].ax;
				if(CD->cellinstancepins[id].ay < miny)	miny = CD->cellinstancepins[id].ay;
				if(CD->cellinstancepins[id].ay > maxy)	maxy = CD->cellinstancepins[id].ay;
			}
			if(draw_box)
				W.draw_rectangle(minx-point_size*scale, miny-point_size*scale, maxx+point_size*scale, maxy+point_size*scale, leda_black);
			if(draw_name)
			{
				leda_string s1 = (leda_string)"("+CD->cellinstances[i].name+(leda_string)")";
				W.draw_text(maxx+point_size*scale, maxy-point_size*scale, s1, leda_black);
			}			
//		}
	}

	if(show_net>=1)
	{
		Net_ *n = &CD->nets[show_net-1];
		double failed = 0;
		cout<<"showing net:"<<show_net<<endl;
		for(int i=0;i<n->pins_uid.size();i++)
		{
			CIP_ *p = &CD->cellinstancepins[n->pins_uid[i]];
			leda_string s1 = p->name;
			leda_string s2 = (leda_string)"("+IntToString((int)CD->nets[show_net-1].max_delay)+(leda_string)")";
			leda_string delay = (leda_string)"("+IntToString((int)p->delay)+(leda_string)")";
			leda_list <leda_edge> e = CD->G.in_edges(p->n);
			Edge_ *ee;
			if(e.first())
				ee = &CD->edges[CD->G.inf(e[e.first()])];
			else
				continue;
			leda_string edge_dis = (leda_string)"("+IntToString((int)ee->distance)+(leda_string)")";
			leda_string route_dis = (leda_string)"("+IntToString((int)ee->dt_grids)+(leda_string)")";
			leda_string vias = (leda_string)"("+IntToString((int)ee->vias)+(leda_string)")";
			W.draw_text(p->ax+point_size*scale, p->ay-point_size*scale, s1+s2+delay+edge_dis+route_dis+vias, leda_white);
			W.draw_disc(p->ax, p->ay, point_size*scale, leda_blue);
			if(!ee->routed)
				failed++;
			else if(ML->multilevel_type == PerformanceDriven)
			{
				if(!ML->SatisfyRestrictedTimingConstraint(ee->target))
					failed++;
				else if(ee->route_type == NerverMeetTiming)
					failed++;
			}
		}
		double s = n->pins_uid.size();
		cout<<"failed local nets:"<<failed<<endl;
		cout<<"Complete ratio for net "<<show_net<<" is :"<<(s-failed)/s<<endl;
	}
	//show pins
	if(draw_name)
	{
		for(int i=0;i<CD->cellinstancepins.size();i++)
		{
			CIP_ *p = &CD->cellinstancepins[i];
			if(p->draw)
			{
				if(!p->ci_uid)	//IO pins
				{
					leda_string s1 = p->name;
					W.draw_text(p->ax+point_size*scale, p->ay-point_size*scale, s1, leda_white);
				}
				if(p->type == IN)
					W.draw_disc(p->ax, p->ay, point_size*scale, leda_red);
				else
					W.draw_disc(p->ax, p->ay, point_size*scale, leda_blue);

			}
		}
	}
	W.draw_rectangle(CD->dmin_x,CD->dmin_y,CD->dmax_x, CD->dmax_y,leda_black);
	
	int start = 0, end = CD->number_of_layers - 1;
	if(!Show_all_layer)
	{
		start = Layers; end = Layers+1;
		if(start == CD->number_of_layers-1)
			end = CD->number_of_layers - 1;
	}
	
	for(int lev = start; lev<=end;lev++)
	for(int i=0;i<ML->levels[0].tiles.size();i++)
	{
		Tile_ t = ML->levels[0].tiles[i];
		if(show_grid)
		{
			W.draw_rectangle(t.lx,t.by,t.rx,t.ty,leda_blue2);
			leda_string s1 = IntToString(i)+(leda_string)"tile";
			W.draw_text(t.lx+point_size*scale, t.by+point_size*scale, s1, leda_white);
		}
		int box_c = leda_blue;
		if(lev == start + 1)
			box_c = leda_red;
		else if(lev == start + 2)
			box_c = leda_green;
		else if(lev == start + 3)
			box_c = leda_grey3;
			

		if(t.dt && Show_Detail_Grid)
		{
			for(int j=0;j<ML->dt_m;j++)
			{
				for(int k=0;k<ML->dt_n;k++)
				{
					int lx = t.lx + j*CD->wire_pitch + CD->wire_spacings/2;
					int rx = t.lx + (j+1)*CD->wire_pitch - CD->wire_spacings/2;
					int by = t.by + k*CD->wire_pitch + CD->wire_spacings/2;
					int ty = t.by + (k+1)*CD->wire_pitch - CD->wire_spacings/2;
					int r_width = CD->wire_widths;
					int pre_lx, pre_rx, pre_by, pre_ty;
					int test = k*ML->dt_m+j;
					if(show_net == -1)
					{
						if(t.dt->layers[lev].grids[test])
						{
							//pinst~
							if(t.dt->layers[lev].grids[test] == CD->PinObstacle)
								W.draw_box(lx,by,rx,ty,leda_grey3);
							else
							{
								W.draw_box(lx,by,rx,ty,box_c);
								if(ML->GetDTGridValue(i, k, j, lev, 1) == t.dt->layers[lev].grids[test])
									W.draw_box(rx,by,rx+r_width,by+r_width,box_c);
								if(ML->GetDTGridValue(i, k, j, lev, -1) == t.dt->layers[lev].grids[test])
									W.draw_box(rx-r_width,by,rx,by+r_width,box_c);
								if(ML->GetDTGridValue(i, k, j, lev, 2) == t.dt->layers[lev].grids[test])
									W.draw_box(lx,ty,rx,ty+r_width,box_c);
								if(ML->GetDTGridValue(i, k, j, lev, -2) == t.dt->layers[lev].grids[test])
									W.draw_box(lx,by-r_width,rx,by,box_c);
							}
						}
					}else
					{
						int tt = t.dt->layers[lev].grids[test];
						if(!tt || tt <= CD->PinObstacle)
							continue;
						int net_i = CD->edges[(-1)*tt-1].source->net_uid;
						if(net_i == show_net-1)
						{
							W.draw_box(lx,by,rx,ty,box_c);
								if(ML->GetDTGridValue(i, k, j, lev, 1) == t.dt->layers[lev].grids[test])
									W.draw_box(rx,by,rx+r_width,by+r_width,box_c);
								if(ML->GetDTGridValue(i, k, j, lev, -1) == t.dt->layers[lev].grids[test])
									W.draw_box(rx-r_width,by,rx,by+r_width,box_c);
								if(ML->GetDTGridValue(i, k, j, lev, 2) == t.dt->layers[lev].grids[test])
									W.draw_box(lx,ty,rx,ty+r_width,box_c);
								if(ML->GetDTGridValue(i, k, j, lev, -2) == t.dt->layers[lev].grids[test])
									W.draw_box(lx,by-r_width,rx,by,box_c);
						}
					}
					if(DT_index)
					{
						leda_string s1;
						s1 = IntToString(t.dt->layers[lev].grids[test]);
						W.draw_text(lx,ty, s1, leda_black);
					}
					pre_lx = lx;
					pre_rx = rx;
					pre_by = by;
					pre_ty = ty;
				}
			}
		}
	}
	int color_i = leda_green;
	if(show_edge)
	for(int i=0;i<CD->edges.size();i++)
	{
		CIP_ source, target;
		CD->GetEdgeST(CD->edges[i].e, source, target);
		if(show_net != -1)
		{
			if(show_net-1 != source.net_uid)
				continue;
		}
		if(!l_shape_routing)
		{
			W.draw_arrow(source.ax, source.ay, target.ax, target.ay, color_i);
			continue;
		}

		color_i = GetColor(CD->edges[i].level);
		if(CD->edges[i].route_type == VLine || CD->edges[i].route_type == HLine)
			W.draw_arrow(source.ax, source.ay, target.ax, target.ay, color_i);
		else if(CD->edges[i].route_type == Unrouted)
			W.draw_arrow(source.ax, source.ay, target.ax, target.ay, color_i);
		else if(CD->edges[i].route_type == TopL)
		{
			int mid_x;
			int mid_y = max(source.ay, target.ay);
			W.draw_arrow(source.ax, mid_y, target.ax, mid_y, color_i);
			if(SameSign(source.ax-target.ax,source.ay-target.ay))
				mid_x = min(source.ax, target.ax);
			else
				mid_x = max(source.ax, target.ax);
			W.draw_arrow(mid_x, source.ay, mid_x, target.ay, color_i);
		}
		else if(CD->edges[i].route_type == LowL)
		{
			int mid_x;
			int mid_y = min(source.ay, target.ay);
			W.draw_arrow(source.ax, mid_y, target.ax, mid_y, color_i);
			if(SameSign(source.ax-target.ax,source.ay-target.ay))
				mid_x = max(source.ax, target.ax);
			else
				mid_x = min(source.ax, target.ax);
			W.draw_arrow(mid_x, source.ay, mid_x, target.ay, color_i);
		}
	}
}

int main (int argc, char **argv)
{
	cout<<"\nProgram started!\n";
	if (argc < 2)
	{
		cerr << "Usage: " << argv[0] << " gdif_filename\n";
		return 1;
	}
	int rtype = 1;
	if (argc > 3)
		rtype = atoi(argv[2]);
	float alpha = 1.5;

	if (argc == 4)
		alpha = atof(argv[3]);
	time_t t;
	srand((unsigned) time(&t));
	float T  = used_time();
	CD = new CustomDesign(argv[1]);

	float a[10];
	if(rtype == 1)
	{
		CD->MinimumSpanningTreeRouting();
		a[0] = Routibility;
		cout << "\nMultilevel Routing for routability needs time(+MST Construction):";
	}
	else
	{
		a[0] = PerformanceDriven;
		cout<<"alpha:"<<alpha<<endl;
		a[1] = alpha;
		cout << "\nMultilevel Routing for performance needs time(+MST Construction):";
	}
	ML = new Multilevel(CD, a);
	cout << used_time(T) <<" sec."<< endl;

	int x_shift_pos = 0, y_shift_pos = 0;	//shift_pos from original
	//border larger 10% than design chip size
	int dmin_x = CD->dmin_x - (int)((CD->dmax_x - CD->dmin_x)*(0.03));
	int dmax_x = (int)(CD->dmax_x*(1.03));
	int dmin_y = CD->dmin_y - (int)((CD->dmax_y - CD->dmin_y)*(0.03));
	int dmax_y = (int)(CD->dmax_y*(1.03));
  
	W.init(dmin_x-x_shift_pos, dmax_x-x_shift_pos, dmin_y-y_shift_pos);
	//add function button
	W.button("+",1);
	W.button("-",2);
	W.button("<-",3);
	W.button("->",4);
	W.button("Up",6);
	W.button("Down",5);
	W.button("Show Cell",7,"Click to switch on/off");
	W.button("Show Pin Name",8,"Click to switch on/off");
	W.button("Show Grid",10,"Click to switch on/off");
	W.button("Switch Layers",15,"Click to switch between different layers");
	W.button("Show Edges",16,"Click to switch on/off");
	W.button("Show Detail Grid",17,"Click to switch on/off");
	W.button("Rand a net",18,"Click to view a random net");
	W.button("Show all layers",19,"Click to switch n/off");
	W.button("Show a net",21,"Click to view a specific net");
	W.button("Exit",99);

	W.display();
	W.set_bg_color(leda_white);
	SetCIDraw(CD);
	while(1)
	{
		W.clear(leda_white);
		W.init((dmin_x)*scale-x_shift_pos, (dmax_x)*scale-x_shift_pos, (dmin_y)*scale-y_shift_pos);
		if(message != "")
			W.message(message);
		ShowNetwork(CD, ML);
		W.del_message();
		int but =  W.read_mouse();
		if (but == 99) break;
		char n[50];
		leda_string s;
		switch (but) {
			case 1:
				scale *= 0.9;
				if(scale <= 0)	scale = 0.01;
				break;
			case 2:
				scale *= 1.1;break;
			case 3:
				x_shift_pos -= (int)((dmax_x - dmin_x)*scale/20);
				break;
			case 4:
				x_shift_pos += (int)((dmax_x - dmin_x)*scale/20);
				break;
			case 5:
				y_shift_pos -= (int)((dmax_y - dmin_y)*scale/20);
				break;
			case 6:
				y_shift_pos += (int)((dmax_y - dmin_y)*scale/20);
				break;
			case 7:
				draw_box = 1-draw_box;
				break;
			case 8:
				draw_name = 1-draw_name;
				break;
			case 10:
				show_grid = 1-show_grid;
				break;
			case 15:
				Layers++;
				Layers = Layers % CD->number_of_layers;
				break;
			case 16:
				show_edge = 1-show_edge;
				break;
			case 17:
				Show_Detail_Grid = 1-Show_Detail_Grid;
				break;
			case 18:
				show_net = rand()%CD->nets.size()+1;
				break;
			case 19:
				Show_all_layer = 1-Show_all_layer;
				break;
			case 21:
				s = W.read_string("Which net you want to see(input net index)?");
				for(int i=0;i<s.length();i++)
					n[i] = s[i];
				n[s.length()] = '\0';
				show_net = atoi((const char*)n);
				if(show_net>CD->nets.size())
					show_net = CD->nets.size();
				break;
			default:  
				break;
		}
	}
	W.close();
	cout<<"\nProgram ended!\n";
}
