//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef CustomDesignH
#define CustomDesignH

#include <LEDA/graph.h>
#include <vector>
#include <string>
#include "layoutdb.h"

//define parameter for 0.18 um CMOS MODEL
//from [DAC 00]Timing-driven hierarchical global routing with wire-sizing and buffer-insertion for VLSI with multi-routing-layer.pdf
#define MinGateResistance 280	//(Ohm)
#define MinGateCapacitance 0.234	//(fF/um)
#define WireResistance 0.076	//(Ohm/um)
#define WireCapacitance 0.044	//(fF/um)
#define FringingCapacitance 0.055	//(fF/um)
#define ViaDelay 22	//(psec)
#define scale_factor 1000	//scale factor used in layoutDB

#if defined(LEDA_STD_IO_HEADERS)
using namespace std;
#endif

enum PinType {IN, OUT, UNKNOWN};
enum RouteType {VLine, HLine, TopL, LowL, Maze, Unrouted, NerverMeetTiming};

struct CellInstance_
{
	int uid;	//unique id for this cell instance
	const char *name;
	double max_delay;
	int draw;	//flag is used to indicate if drawing this cellinstance is enabled?
	int flag;	//flag is used to indicate some information like "propagating"?
	int not_conn_pins;	//pins not connected(when "connected pins" = pins_uid,size()-1
				//or "not connected pins" = 1), output can propagate.
	int pins_after_simplied;	//how many pins the single actually need(after simplication)?
	int outpin;	//point to the output pin's uid
	vector <int> pins_uid;
	CellInstance_()
	{
		name = NULL;
		max_delay = -1;
		pins_uid.clear();
		flag = 0;
		pins_after_simplied = 0;
	}
};
struct Net_
{
	int uid;
	const char *name;
	int flag;	//flag is used to indicate some information like "drawing"
	int source;	//point to the source pin's uid
	vector <int> pins_uid;
	int edge_routed;	//how to route this net?
	double max_delay;	//timing constraint for this net
	double delay_lower_bound;	//delay lower bound of this net(=max delay of a sink of shortest path routing)
	double delay_upper_bound;	//delay upper bound of this net(=max delay of a sink of MST routing)
	Net_()
	{
		name = NULL;
		pins_uid.clear();
		flag = 0;
	}
};

struct CellInstancePin_ 
{
	int uid;	//unique id for this pin
	int ci_uid;	//unique id for cell instance of this pin
	int net_uid;	//unique id for output pin information
	int draw;	//flag is used to indicate if drawing this pin is enabled?
	const char *name;
	leda_node n;	//node after pin is imposed into a Graph
	double d_c;	//downstream capcitance
	double delay;
	int ax, ay;
	PinType type;
	CellInstancePin_()
	{
		delay = 0;
		type = UNKNOWN;
	}
};

typedef CellInstance_ CI_;
typedef CellInstancePin_ CIP_;

struct my_link_list_{
        my_link_list_ *rep_node;
        int rep_set;
        my_link_list_()
        {
                rep_node = NULL;
                rep_set = -1;
        }
};

struct Edge_{
	int uid;
	CIP_ *source;
	CIP_ *target;
	leda_edge e;
	vector <int> tile_routing;
	RouteType route_type;
	int vias;	//how many vias this edge has in detailed_grids?
	int dt_grids;	//how many grids this edge used in detailed_grids?
	vector <int *> dt_route_grids;	//how to detailed route this edge, record pointers of detail grids
					//with this, easy to reroute(for Performance route)
	int distance;	//Manhattan Distance Between source and sink
	bool routed;	//does this edge routed?
	int level;	//which level(Multilevel Routing) is this edge belongs to?
};

class CustomDesign{
  public:
  	CustomDesign(){};
  	CustomDesign(char *filename);
  	~CustomDesign(){};
  	//functions
	CI_* GetCIByName(const char *name);
	CIP_* GetCIPByName(const char *cell_name, const char *pin_name);
	void AssignEdge(int source, int target);
	void ShortestPathRouting();
	void MinimumSpanningTreeRouting();
	void GetEdgeST(leda_edge e, CIP_ &source, CIP_ &target);
	void UpdateEdge(int edges_index, int source, int target);
	int ManhattanDistance(CIP_ cip1, CIP_ cip2);
	double NetElmoreDelay(int net_id, int cpi_id);//, int & vias);	//Calculate delay of a sink from source
	Edge_* GetEdgeIn(int cip_index);
  	//end of functions
  	
	vector <CellInstance_> cellinstances;
	vector <Net_> nets;
	vector <CellInstancePin_> cellinstancepins;
	vector <int> distance_label_ci;	//ΨӰO(label)C@ciprimary inputZ(Htopology orderpA֥[1)
	vector <Edge_> edges;
	/*
		Only cell instance map is needed.
		Because number of instance is large.
	*/
	map<string,int> Cimap;	//map used for cell instances;
	//rectangle enclose this CustomDesign
	int dmin_x, dmax_x, dmin_y, dmax_y;
	//wire_pitch = wire_spacings + wire_widths
	int number_of_layers, wire_spacings, wire_widths, wire_pitch;
	int PinObstacle;
	int NetPin;
	GRAPH <int, int> G;	//connection graph for design
	LayoutDatabase ldb;
    
  private:
	double DownStreamCapaciteance(int net_id, int cpi_id);
	PinType GetPinType(const char* name);
	void Init();
};
//---------------------------------------------------------------------------
#endif