/* 
 * Ryan Kastner
 * 1.13.2000
 */

import java.awt.*;
import java.awt.event.*;

public class MenuActionListener implements ActionListener
{
  public MenuActionListener(CongestionFrame frame)
  {
    congestionFrame = frame;
    ecDialog = null;
  }

  public void actionPerformed(ActionEvent e)
  {
    if(e.getActionCommand().compareTo("menu_load") == 0)
      menuLoad();
    else if(e.getActionCommand().compareTo("menu_exit") == 0)
      menuExit();
    else if(e.getActionCommand().compareTo("preferences_edgeColors") == 0)
      menuEdgeColors();
    else if(e.getActionCommand().compareTo("preferences_congestion_text") == 0)
      menuCongestionText();
    
  }

  private void menuLoad()
  {
    FileDialog fd = new FileDialog(congestionFrame, "Find file", 
				   FileDialog.LOAD);
    fd.show();
    FileParser parser = new FileParser();
    Bin newBin = null;
    try{ newBin = parser.parseFile(fd.getDirectory() + fd.getFile()); }
    catch(java.io.FileNotFoundException e)
      { System.out.println("File not found"); }
    congestionFrame.setBin(newBin);
    congestionFrame.setTitle("Congestion - " + fd.getFile());

  }

  private void menuExit()
  {
    System.exit(1);
  }

  private void menuEdgeColors()
  {
    if(ecDialog == null)
      ecDialog = new EdgeColorDialog(congestionFrame);
    else
      ecDialog.setVisible(true);
  }

  private void menuCongestionText()
  {
    congestionFrame.toggleCongestionText();
  }
    

  //private variables
  CongestionFrame congestionFrame;
  EdgeColorDialog ecDialog;
}
