/* 
 * Ryan Kastner
 * 1.15.2000
 */

import java.awt.*;
import java.awt.event.*;

public class EdgeColorDialog extends Dialog 
implements TextListener,ActionListener
{

  //constructor
  EdgeColorDialog(CongestionFrame cFrame)
  {
    super((Frame) cFrame,"Edge Colors",true);
    parent = cFrame;
    makeDialog();
    setSize(375,250);
    setLocation(parent.getLocationOnScreen());
    setVisible(true);
    red = 150;
    orange = 125;
    yellow = 100;
    green = 75;
    blue = 50;
    magenta = 25;
    congestion = 5;
  }

  private void newMakeDialog()
  {
    setLayout(new BorderLayout());
    Panel centerPanel = new Panel(new FlowLayout());
    

    Panel northCongestionPanel = new Panel(new FlowLayout());
    northCongestionPanel.add(new Label("Congestion"));
    TextField congestionTF = new TextField(4);
    congestionTF.setName("congestionTF");
    northCongestionPanel.add(congestionTF);
    congestionTF.addTextListener(this);
    congestionTF.setText("5");
    add("North", northCongestionPanel);
        

    centerPanel.add(new Label("Red above :"));
    TextField redTF = new TextField(3);
    redTF.setName("redTF");
    redTF.setText("150");
    centerPanel.add(redTF);
    centerPanel.add(new Label(" %; Yellow above :"));
    TextField yellowTF = new TextField(3);
    yellowTF.setName("yellowTF");
    yellowTF.setText("130");
    centerPanel.add(yellowTF);
    centerPanel.add(new Label(" %; Orange above :"));

    add("Center",centerPanel);
    
    Panel southPanel = new Panel(new FlowLayout());
    Button ok = new Button("Ok");
    ok.setActionCommand("Ok");
    ok.addActionListener(this);
    Button cancel = new Button("Cancel");
    cancel.setActionCommand("Cancel");
    cancel.addActionListener(this);
    southPanel.add(ok);
    southPanel.add(cancel);

    add("South", southPanel);

  }


  private void makeDialog()
  {
    setLayout(new BorderLayout());
    Panel centerPanel = new Panel(new GridLayout(0,1));
    

    Panel centerCongestionPanel = new Panel(new FlowLayout());
    centerCongestionPanel.add(new Label("Congestion"));
    TextField congestionTF = new TextField(4);
    congestionTF.setName("congestionTF");
    centerCongestionPanel.add(congestionTF);
    congestionTF.addTextListener(this);
    congestionTF.setText("5");
    centerPanel.add(centerCongestionPanel);
    
    Panel centerRedPanel = new Panel(new FlowLayout());
    centerRedPanel.add(new Label("Color edge red if congestion above :"));
    TextField redTF = new TextField(3);
    redTF.setName("redTF");
    redTF.setText("150");
    redTF.addTextListener(this);
    centerRedPanel.add(redTF);
    centerRedPanel.add(new Label(" %"));
    centerPanel.add(centerRedPanel);

    Panel centerOrangePanel = new Panel(new FlowLayout());
    centerOrangePanel.add(new 
			  Label("Color edge orange if congestion above :"));
    TextField orangeTF = new TextField(3);
    orangeTF.setName("orangeTF");
    orangeTF.setText("125");
    orangeTF.addTextListener(this);
    centerOrangePanel.add(orangeTF);
    centerOrangePanel.add(new Label(" %"));
    centerPanel.add(centerOrangePanel);

    Panel centerYellowPanel = new Panel(new FlowLayout());
    centerYellowPanel.add(new 
			  Label("Color edge yellow if congestion above :"));
    TextField yellowTF = new TextField(3);
    yellowTF.setName("yellowTF");
    yellowTF.setText("100");
    yellowTF.addTextListener(this);
    centerYellowPanel.add(yellowTF);
    centerYellowPanel.add(new Label(" %"));
    centerPanel.add(centerYellowPanel);  
       
    Panel centerGreenPanel = new Panel(new FlowLayout());
    centerGreenPanel.add(new 
			  Label("Color edge green if congestion above :"));
    TextField greenTF = new TextField(3);
    greenTF.setName("greenTF");
    greenTF.setText("75");
    greenTF.addTextListener(this);
    centerGreenPanel.add(greenTF);
    centerGreenPanel.add(new Label(" %"));
    centerPanel.add(centerGreenPanel);

    Panel centerBluePanel = new Panel(new FlowLayout());
    centerBluePanel.add(new 
			  Label("Color edge blue if congestion above :"));
    TextField blueTF = new TextField(3);
    blueTF.setName("blueTF");
    blueTF.setText("50");
    blueTF.addTextListener(this);
    centerBluePanel.add(blueTF);
    centerBluePanel.add(new Label(" %"));
    centerPanel.add(centerBluePanel);

    Panel centerMagentaPanel = new Panel(new FlowLayout());
    centerMagentaPanel.add(new 
			  Label("Color edge magenta if congestion above :"));
    TextField magentaTF = new TextField(3);
    magentaTF.setName("magentaTF");
    magentaTF.setText("25");
    magentaTF.addTextListener(this);
    centerMagentaPanel.add(magentaTF);
    centerMagentaPanel.add(new Label(" %"));
    centerPanel.add(centerMagentaPanel);

    add("Center",centerPanel);
    
    Panel southPanel = new Panel(new FlowLayout());
    Button ok = new Button("Ok");
    ok.setActionCommand("Ok");
    ok.addActionListener(this);
    Button cancel = new Button("Cancel");
    cancel.setActionCommand("Cancel");
    cancel.addActionListener(this);
    southPanel.add(ok);
    southPanel.add(cancel);

    add("South", southPanel);

  }


  //text listener function
  public void textValueChanged(TextEvent e)
  {
    if(e.getSource() instanceof TextField)
      {
	TextField eventThrower = (TextField) e.getSource();
	String throwerName = eventThrower.getName();
	if(throwerName.compareTo("congestionTF") == 0)
	  congestion = Integer.valueOf(eventThrower.getText()).intValue();
	else if(throwerName.compareTo("redTF") == 0)
	  red = Integer.valueOf(eventThrower.getText()).intValue();
	else if(throwerName.compareTo("orangeTF") == 0)
	  orange = Integer.valueOf(eventThrower.getText()).intValue();
	else if(throwerName.compareTo("yellowTF") == 0)
	  yellow = Integer.valueOf(eventThrower.getText()).intValue();
	else if(throwerName.compareTo("greenTF") == 0)
	  green = Integer.valueOf(eventThrower.getText()).intValue();
	else if(throwerName.compareTo("blueTF") == 0)
	  blue = Integer.valueOf(eventThrower.getText()).intValue();
	else if(throwerName.compareTo("magentaTF") == 0)
	  magenta = Integer.valueOf(eventThrower.getText()).intValue();
      }

  } 

  //action listener function
  public void actionPerformed(ActionEvent e)
  {
    if(e.getActionCommand().compareTo("Ok") == 0)
      {
	saveVariables();
	setVisible(false);
      }
    else if(e.getActionCommand().compareTo("Cancel") == 0)
      {
	setVisible(false);
      }
  }

  private void saveVariables()
  { parent.setEdgeColors(red,orange,yellow,green,blue,magenta,congestion); }

  //private variables
  CongestionFrame parent;
  private int red,orange,yellow,green,blue,magenta,congestion;
}
