/*
 * Ryan Kastner
 * 1.13.2000
 * 
 */

import java.awt.*;

public class CongestionFrame extends Frame
{
  public CongestionFrame()
  {
    windowListen = new CongestionFrameWindowListener(this);
    createFrameComponents();
    createMenubar();
  }
 
  public CongestionFrame(String title)
  {
    setTitle(title);
    windowListen = new CongestionFrameWindowListener(this);
    createFrameComponents();
    createMenubar();
  }
  
  private void createFrameComponents()
  {
    drawCanvas = new CongestionCanvas();
    edgeColors = new EdgeColors();
    drawCanvas.setEdgeColors(edgeColors);
    setLayout(new BorderLayout());
    add("Center", drawCanvas);
    setSize(400,400);
  }

  private void createMenubar()
  {
    menuActionListener = new MenuActionListener(this);
    menubar = new MenuBar();
    Menu file = new Menu("File");
    MenuItem load = new MenuItem("Load file...");
    load.setActionCommand("menu_load");
    load.addActionListener(menuActionListener);
    MenuItem exit = new MenuItem("Exit");
    exit.setActionCommand("menu_exit");
    exit.addActionListener(menuActionListener);
    file.add(load);
    file.insertSeparator(2);
    file.add(exit);
    menubar.add(file);

    Menu preferences = new Menu("Preferences");
    MenuItem edgeColors = new MenuItem("Edge colors...");
    edgeColors.setActionCommand("preferences_edgeColors");
    edgeColors.addActionListener(menuActionListener);
    MenuItem misc = new MenuItem("Toggle congestion text");
    misc.setActionCommand("preferences_congestion_text");
    misc.addActionListener(menuActionListener);
    preferences.add(edgeColors);
    preferences.add(misc);
    menubar.add(preferences);

    setMenuBar(menubar);
  }

  //modifiers
  public void setNumVertLines(int setLines)
  { drawCanvas.setNumVertLines(setLines); }

  public void setNumHorizLines(int setLines)
  { drawCanvas.setNumHorizLines(setLines); }

  public void setBin(Bin aBin)
  { bin = aBin; drawCanvas.setBin(bin); }

  public void setEdgeColors(int red, int orange, int yellow, int green,
			    int blue, int magenta, int congest)
  { 
    edgeColors.resetColors(red,orange,yellow,green,blue,magenta,congest);
    drawCanvas.setEdgeColors(edgeColors); 
  }

  public void toggleCongestionText()
  {
    drawCanvas.toggleCongestionText();
  }
 
  //private variables
  private CongestionCanvas drawCanvas;
  private CongestionFrameWindowListener windowListen;
  private MenuBar menubar;
  private MenuActionListener menuActionListener;
  private Bin bin;
  private EdgeColors edgeColors;

}
