/*
 * Ryan Kastner
 * 1.13.2000
 */

import java.awt.*;

public class CongestionCanvas extends Canvas
{

  //constructors
  CongestionCanvas()
  {
    bin = null;
    edgeColors = null;
    displayCongestion = true;
  }

  //modifiers
  public void setNumVertLines(int numLines)
  { numVertLines = numLines; }

  public void setNumHorizLines(int numLines)
  { numHorizLines = numLines; }

  public void setBin(Bin aBin)
  { bin = aBin; repaint(); }

  public void setEdgeColors(EdgeColors newEC)
  { edgeColors = newEC; repaint(); }

  public void toggleCongestionText()
  {
    if(displayCongestion == true)
      displayCongestion = false;
    else
      displayCongestion = true;
    repaint();
  }

  public void paint(Graphics g)
  {
    setBackground(Color.white);
    if(bin != null)
      drawGrid(g);
    
    
  }

  private void drawGrid(Graphics g)
  {
    int borderlength = 20;
    Dimension d = getSize();
    g.setColor(Color.black);
    g.translate(borderlength,borderlength);
    int gridWidth = d.width - 2*borderlength;
    int gridHeight = d.height - 2*borderlength;
    int numVertRows = bin.getNumVertRows();
    int numHorizRows = bin.getNumHorizRows();
    boolean colorEdges = false;
    if(edgeColors != null)
      colorEdges = true;

    //draw horizontal bins
    for(int i = 0; i < numHorizRows; i++)
      {
	for(int j = 0; j < numVertRows-1; j++)
	  {
	    int congestion = bin.getHorizEdgeAt(i,j).getCongestion();
	    if(colorEdges)
	      g.setColor(edgeColors.getColor(congestion));
	    
	    g.drawLine(j*(gridWidth/(numVertRows-1)),
		       i*(gridHeight/(numHorizRows-1)),
		       (j+1)*(gridWidth/(numVertRows-1)),
		       (i)*(gridHeight/(numHorizRows-1)));
	    g.setColor(Color.black);
	    if(displayCongestion)
	      g.drawString(Integer.toString(congestion), 
			   j*(gridWidth/(numVertRows-1))+
			   (int) (.5*(gridWidth/(numVertRows-1))), 
			   i*(gridHeight/(numHorizRows-1)) + 
			   g.getFontMetrics().getAscent());
	  }
      }
    for(int i = 0; i < numVertRows; i++)
      {
	for(int j = 0; j < numHorizRows-1; j++)
	  {
	    int congestion = bin.getVertEdgeAt(i,j).getCongestion();
	    if(colorEdges)
	      g.setColor(edgeColors.getColor(congestion));
	    g.drawLine(i*(gridWidth/(numVertRows-1)),
		       j*(gridHeight/(numHorizRows-1)),
		       i*(gridWidth/(numVertRows-1)),
		       (j+1)*(gridHeight/(numHorizRows-1)));
	    g.setColor(Color.black);
	    if(displayCongestion)
	      g.drawString(Integer.toString(congestion),
			   i*(gridWidth/(numVertRows-1)),
			   j*(gridHeight/(numHorizRows-1)) + 
			   (int)(.5*(gridHeight/(numHorizRows-1))) + 
			   (int) (g.getFontMetrics().getAscent()/2));
	    
	  }
      }
			  
  }

  

  //private variables
  private int numVertLines;
  private int numHorizLines;
  private Bin bin;
  private EdgeColors edgeColors;
  private boolean displayCongestion;

}
    
